/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.index.core;

import com.aptana.core.util.StringUtil;
import com.aptana.index.core.Messages;
import com.aptana.sax.Schema;
import com.aptana.sax.SchemaBuilder;
import com.aptana.sax.SchemaInitializationException;
import com.aptana.sax.ValidatingReader;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class MetadataReader
extends ValidatingReader {
    private static final Map<String, String> ENTITY_MAP;
    private static final Pattern ENTITY_PATTERN;
    private static final Pattern LEADING_WHITESPACE;
    private static final Pattern TRAILING_WHITESPACE;
    private static final Pattern WHITESPACE;
    private boolean _bufferText;
    private StringBuffer _textBuffer = new StringBuffer();
    private Schema _metadataSchema;

    static {
        LEADING_WHITESPACE = Pattern.compile("^\\s+");
        TRAILING_WHITESPACE = Pattern.compile("\\s+$");
        WHITESPACE = Pattern.compile("\\s+");
        ENTITY_MAP = new HashMap<String, String>();
        ENTITY_MAP.put("&amp;", "&");
        ENTITY_MAP.put("&quot;", "\"");
        ENTITY_MAP.put("&lt;", "<");
        ENTITY_MAP.put("&gt;", ">");
        ArrayList<String> entities = new ArrayList<String>();
        entities.add("&(?:(\\\\d+)|x([a-zA-Z0-9]+));");
        for (String entity : ENTITY_MAP.keySet()) {
            entities.add(Pattern.quote(entity));
        }
        ENTITY_PATTERN = Pattern.compile(StringUtil.join((String)"|", entities));
    }

    public void characters(char[] buffer, int offset, int length) {
        if (this._bufferText) {
            this._textBuffer.append(new String(buffer, offset, length));
        }
    }

    protected abstract InputStream getSchemaStream();

    protected String getText() {
        String result = this._textBuffer.toString();
        this._textBuffer.setLength(0);
        this._bufferText = false;
        return result;
    }

    public boolean isBufferingText() {
        return this._bufferText;
    }

    private void loadMetadataSchema() throws Exception {
        InputStream schemaStream;
        if (this._metadataSchema == null && (schemaStream = this.getSchemaStream()) != null) {
            try {
                try {
                    this._schema = this._metadataSchema = SchemaBuilder.fromXML((InputStream)schemaStream);
                }
                catch (SchemaInitializationException e) {
                    String msg = Messages.MetadataReader_ErrorLoadingDocumentationXML;
                    Exception ie = new Exception(msg, e);
                    throw ie;
                }
            }
            finally {
                try {
                    schemaStream.close();
                }
                catch (IOException e) {
                    String msg = Messages.MetadataReader_IOErrorProcessingDocumentationXML;
                    Exception ie = new Exception(msg, e);
                    throw ie;
                }
            }
        }
    }

    public void loadXML(InputStream stream) throws Exception {
        this.loadXML(stream, null);
    }

    public void loadXML(InputStream stream, String inputName) throws Exception {
        this.loadMetadataSchema();
        if (this._metadataSchema != null) {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            this.getText();
            SAXParser saxParser = null;
            try {
                saxParser = factory.newSAXParser();
                saxParser.parse(stream, (DefaultHandler)((Object)this));
            }
            catch (ParserConfigurationException e) {
                String msg = Messages.MetadataReader_SAXParserConfiguredIncorrectly;
                Exception de = new Exception(msg, e);
                throw de;
            }
            catch (SAXException e) {
                Exception ex = e.getException();
                if (StringUtil.isEmpty((String)inputName)) {
                    inputName = "the documentation XML file";
                }
                String msg = MessageFormat.format(Messages.MetadataReader_ErrorParsingDocumentationXML, inputName, ex != null ? ex.getMessage() : e.getMessage());
                throw new Exception(msg, e);
            }
            catch (IOException e) {
                String msg = Messages.MetadataObjectsReader_IOErrorOccurredProcessingDocumentationXML;
                Exception de = new Exception(msg, e);
                throw de;
            }
        }
    }

    public String normalizeText(String text) {
        String result = null;
        if (text != null) {
            result = LEADING_WHITESPACE.matcher(text).replaceAll("");
            result = TRAILING_WHITESPACE.matcher(result).replaceAll("");
            result = WHITESPACE.matcher(result).replaceAll(" ");
        }
        return result;
    }

    private String numericStringToString(String text, int base) {
        String result = null;
        if (text != null && text.length() > 0) {
            try {
                int charCode = Integer.parseInt(text, base);
                char[] chars = Character.toChars(charCode);
                result = new String(chars);
            }
            catch (NumberFormatException e) {
                result = text;
            }
        }
        return result;
    }

    protected String resolveEntities(String text) {
        String result = text;
        if (text != null && text.length() > 0) {
            StringBuffer buffer = new StringBuffer();
            Matcher m = ENTITY_PATTERN.matcher(text);
            while (m.find()) {
                String replaceText = this.numericStringToString(m.group(1), 10);
                if (replaceText == null) {
                    replaceText = this.numericStringToString(m.group(2), 16);
                }
                if (replaceText == null) {
                    replaceText = ENTITY_MAP.get(m.group());
                }
                if (replaceText == null) {
                    replaceText = m.group();
                }
                m.appendReplacement(buffer, replaceText);
            }
            m.appendTail(buffer);
            result = buffer.toString();
        }
        return result;
    }

    public void startTextBuffer() {
        this._bufferText = true;
    }

    public void startTextBuffer(String ns, String name, String qname, Attributes attributes) {
        this.startTextBuffer();
    }
}

